<?php

namespace App\Http\Controllers;

use App\Models\Hadiah;
use App\Models\Member;
use App\Models\Poinbelanja;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\Printer;

class TukarpoinController extends Controller
{
    public function index()
    {
        $poin = Poinbelanja::pencarian()->where('sts_poin', 'K')->latest()->paginate(10);
        $hadiah = Hadiah::pencarian()->latest()->paginate(12);
        $data = [
            'title' => 'Ramizah Store | Tukar Poin Belanja',
            'page' => 'Tukar Poin Belanja',
            'menuActive' => 'tukar',
            'menuOpen' => 'tukar',
        ];
        return view('kasir.tukar.poin', compact('data', 'hadiah', 'poin'))->with('no', 1);
    }

    public function pilih_hadiah(Request $request)
    {
        $c = Hadiah::where('id', $request->id)->first();
        $stok = $c->stok - stok_item($c->kd_hadiah);
        if (!empty($stok)) {
            $data = [
                'hasil' => 'ada',
                'kode' => $c->kd_hadiah,
                'nama' => $c->nm_hadiah,
                'stok' => $stok,
                'poin' => $c->poin,
            ];
        } else {
            $data = [
                'hasil' => 'kosong',
                'kode' => "",
                'nama' => "",
                'stok' => "",
                'poin' => "",
            ];
        }
        return response()->json($data);
    }

    public function cari_member_item(Request $request)
    {
        $c = Member::where('kd_member', $request->kode)->first();
        if (!empty($c)) {
            $jml_poin = poinmasuk($c->id) - poinkeluar($c->id);
            $data = [
                'hasil' => 'ada',
                'id' => $c->id,
                'kode' => $c->kd_member,
                'nama' => $c->nm_member,
                'alamat' => $c->ongkirmember->alamat,
                'poin' =>  $jml_poin,
            ];
        } else {
            $data = [
                'hasil' => 'kosong',
                'id' => "0",
                'kode' => "",
                'nama' => "",
                'alamat' => "",
                'poin' => "",
            ];
        }
        return response()->json($data);
    }

    public function simpan_penukaran(Request $request)
    {
        $id = Poinbelanja::create([
            'user_id' => Auth::user()->id,
            'member_id' => $request->id,
            'kodetran' => $request->kode,
            'jml_poin' => $request->poin,
            'sts_poin' => 'K',
        ])->id;
        return response()->json($id);
    }

    public function cetak_penukaran(Request $request)
    {
        if (modull('PRINT')->status == 'N') {
            $d = Poinbelanja::where('id', $request->id)->first();
            return view('kasir.tukar.cetak', compact('d'));
        } else {
            $d = Poinbelanja::where('id', $request->id)->first();
            $tgl = date('d-m-Y H:i', strtotime($d->created_at));

            $poin = poinmasuk($d->member_id) - poinkeluar($d->member_id) + $d->jml_poin;

            $connector = new WindowsPrintConnector(modull('PRINT')->isi);
            $printer = new Printer($connector);

            $printer->initialize();
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text(modull('PNT')->judul . "\n");
            $printer->text(modull('PNT')->gambar . " - " . modull('PNT')->link . "\n");
            $printer->text(modull('PNT')->isi . "\n");
            $printer->text("================================\n");

            $printer->initialize();
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text(printer_cek("Ktr        :", "Penukaran Poin") . "\n");
            $printer->text(printer_cek("Tanggal    :", $tgl) . "\n");
            $printer->text(printer_cek("Member     :", $d->member->nm_member) . "\n");
            $printer->text(printer_cek("Ptg. Entry :", $d->user->nm_user) . "\n");
            $printer->text("================================\n");

            $printer->initialize();
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text(hadiah($d->kodetran)->nm_hadiah . "\n");
            $printer->text(printer_cek("Jml. Poin", number_format($d->jml_poin, 0, ',', '.')) . "\n");
            $printer->text(printer_cek("Poin Member", number_format($poin, 0, ',', '.')) . "\n");
            $printer->text("================================\n");
            $printer->text(printer_cek("Sisa Poin", number_format(poinmasuk($d->member_id) - poinkeluar($d->member_id), 0, ',', '.')) . "\n");
            $printer->text("================================\n");

            $printer->initialize();
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text(modull('PTX')->judul . "\n");
            $printer->feed(1);
            $printer->text(modull('PTX')->link . "\n");

            $printer->feed(3);
            $printer->close();
            return response()->json();
        }
    }

    public function tukarpoin()
    {
        $poin = Poinbelanja::pencarian()->where('sts_poin', 'K')->latest()->paginate(10);
        $data = [
            'title' => 'Ramizah Store | Penukaran Poin',
            'page' => 'Penukaran Poin',
            'menuActive' => 'tukar',
            'menuOpen' => 'tukar',
        ];
        return view('admin.data.tukarpoin', compact('data', 'poin'))->with('no', 1);
    }

    public function destroy_all_penukaran(Request $request)
    {
        $ids = $request->allVals;
        foreach ($ids as  $id) {
            Poinbelanja::findOrFail($id)->delete();
        }
        return response()->json();
    }
}
